//+------------------------------------------------------------------+
//|                                                 TestDatabase.mq5 |
//|                        Copyright 2025, MetaQuotes Software Corp. |
//|                   https://www.mql5.com/en/users/swedishforexking |
//+------------------------------------------------------------------+
#property copyright "Copyright 2025, MetaQuotes Software Corp."
#property link      "https://www.mql5.com/en/users/swedishforexking"
#property version   "2.00"

#include "DatabaseORM v2.0.mqh"
#include "TradeReportModel v2.0.mqh"


//+------------------------------------------------------------------+
void OnStart()
  {

   uint db_flags = DATABASE_OPEN_READWRITE | DATABASE_OPEN_CREATE;

   CDatabaseORM orm;
   orm.Connect("test.db", db_flags);

   CBaseModel model;
   model.Table("test_table");

   CORMField *id=new CORMField("id",FIELD_TYPE_INT);
   id.PrimaryKey(true);
   id.AutoIncrement(true);

   CORMField *name=new CORMField("name",FIELD_TYPE_STRING);
   name.SetValue("Alice");

   model.AddField(id);
   model.AddField(name);

   orm.CreateTable(model);
   orm.Insert(model);


   TradeReportModel r;

   r.Set("Symbol","EURUSD");
   r.Set("Lots","0.2");

   Print(r.Get("Symbol"));
   Print(r.Get("Lots"));



   CDatabaseORM db;
   db.Connect("trade.db", db_flags);


// --- Insert
   TradeReportModel report;
   report.Symbol   = "EURUSD";
   report.Lots     = 0.10;
   report.OpenTime = TimeCurrent();

   db.CreateTable(report);
   db.Insert(report);

// --- Retrieve
   TradeReportModel loaded;
   if(db.Select(loaded,"Symbol='EURUSD'"))
     {
      Print("Loaded: ",loaded.Symbol," ",loaded.Lots);
     }

// --- Update
   loaded.Lots = 0.20;
   db.Update(loaded);

// --- Soft delete
   db.Delete(loaded);
  }
//+------------------------------------------------------------------+
